/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections;

import java.util.Collection;
import org.apache.commons.collections.Buffer;
import org.apache.commons.collections.BufferUnderflowException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;

public class BufferUtils {
    private BufferUtils() {
    }

    public static Buffer blockingBuffer(Buffer buffer) {
        return new SynchronizedBuffer(buffer){

            public synchronized Object get() {
                while (this.collection.isEmpty()) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        throw new BufferUnderflowException();
                    }
                }
                return ((Buffer)this.collection).get();
            }

            public synchronized Object remove() {
                while (this.collection.isEmpty()) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        throw new BufferUnderflowException();
                    }
                }
                return ((Buffer)this.collection).remove();
            }

            public synchronized boolean add(Object object) {
                boolean bl = this.collection.add(object);
                this.notify();
                return bl;
            }

            public synchronized boolean addAll(Collection collection) {
                boolean bl = this.collection.addAll(collection);
                this.notifyAll();
                return bl;
            }
        };
    }

    public static Buffer synchronizedBuffer(Buffer buffer) {
        return new SynchronizedBuffer(buffer);
    }

    public static Buffer unmodifiableBuffer(Buffer buffer) {
        return new UnmodifiableBuffer(buffer);
    }

    public static Buffer predicatedBuffer(Buffer buffer, Predicate predicate) {
        return new PredicatedBuffer(buffer, predicate);
    }

    static class PredicatedBuffer
    extends CollectionUtils.PredicatedCollection
    implements Buffer {
        public Object get() {
            return ((Buffer)this.collection).get();
        }

        public Object remove() {
            return ((Buffer)this.collection).remove();
        }

        public PredicatedBuffer(Buffer buffer, Predicate predicate) {
            super(buffer, predicate);
        }
    }

    static class SynchronizedBuffer
    extends CollectionUtils.SynchronizedCollection
    implements Buffer {
        public synchronized Object get() {
            return ((Buffer)this.collection).get();
        }

        public synchronized Object remove() {
            return ((Buffer)this.collection).remove();
        }

        public SynchronizedBuffer(Buffer buffer) {
            super(buffer);
        }
    }

    static class UnmodifiableBuffer
    extends CollectionUtils.UnmodifiableCollection
    implements Buffer {
        public Object get() {
            return ((Buffer)this.collection).get();
        }

        public Object remove() {
            throw new UnsupportedOperationException();
        }

        public UnmodifiableBuffer(Buffer buffer) {
            super(buffer);
        }
    }
}

